//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Outlaws
//  Copyright (C) 2016 RETROBYTES PRODUCTIONS
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include "sprites.h"

const u8 G_marcador[10][MARCADOR_W * MARCADOR_H] = {
{0x5D, 0xAE,
	0xEA, 0xD5,
	0xAE, 0x5D,
	0xAE, 0x5D,
	0xAE, 0x5D,
	0xAE, 0x5D,
	0xD5, 0xEA,
	0x48, 0x84},
{
	0x0C, 0xAE,
	0x5D, 0xAE,
	0x48, 0xAE,
	0x0C, 0xAE,
	0x0C, 0xAE,
	0x0C, 0xAE,
	0x5D, 0xFF,
	0x48, 0xC0},
{
	0x5D, 0xAE,
	0xEA, 0xD5,
	0x84, 0x5D,
	0x5D, 0xEA,
	0xEA, 0x84,
	0xAE, 0x0C,
	0xFF, 0xFF,
	0xC0, 0xC0},
{
	0xFF, 0xFF,
	0xC0, 0xD5,
	0x0C, 0x5D,
	0x0C, 0xEA,
	0x0C, 0xD5,
	0xAE, 0x5D,
	0xD5, 0xEA,
	0x48, 0x84},
{
	0xAE, 0xAE,
	0xAE, 0xAE,
	0xAE, 0xAE,
	0xFF, 0xAE,
	0xC0, 0xAE,
	0x0C, 0xAE,
	0x5D, 0xFF,
	0x48, 0xC0},
{
	0xFF, 0xFF,
	0xEA, 0xC0,
	0xAE, 0x0C,
	0xD5, 0xAE,
	0x48, 0xD5,
	0xAE, 0x5D,
	0xD5, 0xEA,
	0x48, 0x84},
{
	0x5D, 0xAE,
	0xEA, 0xD5,
	0xAE, 0x48,
	0xFF, 0xAE,
	0xEA, 0xD5,
	0xAE, 0x5D,
	0xD5, 0xEA,
	0x48, 0x84},
{
	0xFF, 0xFF,
	0xEA, 0xD5,
	0x84, 0x5D,
	0x0C, 0xEA,
	0x0C, 0xAE,
	0x0C, 0xAE,
	0x5D, 0xFF,
	0x48, 0xC0},
{
	0x5D, 0xAE,
	0xEA, 0xD5,
	0xAE, 0x5D,
	0xD5, 0xEA,
	0xEA, 0xD5,
	0xAE, 0x5D,
	0xD5, 0xEA,
	0x48, 0x84},
{
	0x5D, 0xAE,
	0xEA, 0xD5,
	0xAE, 0x5D,
	0xD5, 0xFF,
	0x48, 0xD5,
	0xAE, 0x5D,
	0xD5, 0xEA,
	0x48, 0x84}

};

/****** FONTS ************/

//const u8 G_number[10][FONT_H * FONT_W];
//const u8 G_font[27][FONT_H * FONT_W];

const u8 EXO_font[373] = {
	 0x80, 0x90, 0x10, 0x08, 0x08, 0x00, 0x00, 0x00, 0x10, 0x84, 0x40, 0x90, 0x00, 0x4c, 0xcd, 0x2c,
	 0x10, 0x18, 0x18, 0x01, 0x88, 0x15, 0x51, 0x2d, 0x10, 0x04, 0x5f, 0x04, 0x0c, 0x00, 0xcc, 0x14,
	 0x88, 0x86, 0x5a, 0x22, 0x25, 0xc2, 0x33, 0x42, 0xeb, 0x9b, 0x8a, 0x45, 0xcd, 0xcf, 0x44, 0x08,
	 0xed, 0x44, 0x30, 0x52, 0x8e, 0xb1, 0x11, 0xc7, 0x88, 0x24, 0x0c, 0x24, 0x4d, 0x84, 0x52, 0x34,
	 0x8a, 0x67, 0x45, 0x90, 0x54, 0xba, 0x05, 0x48, 0x8c, 0xe9, 0x6a, 0x84, 0x4b, 0x57, 0x52, 0x29,
	 0xe2, 0xc8, 0x04, 0x4d, 0x91, 0x44, 0x12, 0xb2, 0xb4, 0x9b, 0x2a, 0xe8, 0x18, 0x71, 0x46, 0x08,
	 0x99, 0xcd, 0x54, 0x2c, 0xc0, 0x0c, 0x04, 0x14, 0x6e, 0x07, 0xf7, 0x87, 0xa6, 0x49, 0xce, 0x0b,
	 0x6a, 0x60, 0x7f, 0x9c, 0x0a, 0x49, 0x45, 0x7a, 0xe0, 0x04, 0x0a, 0x1e, 0x0e, 0x58, 0x3d, 0xe0,
	 0x60, 0x50, 0xa0, 0x5d, 0x14, 0x28, 0x87, 0x10, 0x20, 0xe5, 0x98, 0x30, 0x5a, 0xf0, 0xd8, 0x23,
	 0x6c, 0x38, 0x9a, 0x28, 0xa6, 0x34, 0x09, 0x5d, 0x3c, 0x64, 0xbd, 0x50, 0xb7, 0x50, 0xa3, 0xa0,
	 0x85, 0x3c, 0x27, 0x9a, 0x9a, 0x08, 0x70, 0xda, 0x33, 0x4f, 0xc4, 0x92, 0x34, 0x9e, 0x10, 0x0e,
	 0x4e, 0x2a, 0x22, 0x28, 0xf1, 0xf4, 0x30, 0x71, 0x9c, 0x12, 0x2a, 0x4a, 0x37, 0x03, 0x4c, 0x52,
	 0x00, 0x8e, 0x91, 0x06, 0x58, 0xf5, 0xa1, 0x50, 0xd5, 0x2b, 0xb7, 0x2b, 0xff, 0x4e, 0xa2, 0xd7,
	 0x21, 0x02, 0x1c, 0x1d, 0xe5, 0x44, 0xcc, 0xba, 0x10, 0x98, 0x0a, 0x87, 0x71, 0x14, 0x3c, 0x8c,
	 0x2c, 0x4d, 0xe6, 0x76, 0xe5, 0xd4, 0x64, 0xcc, 0x41, 0x06, 0xe0, 0xd4, 0x34, 0xf1, 0x38, 0xfa,
	 0xfc, 0x7b, 0xce, 0xcc, 0xc6, 0x92, 0xa5, 0x93, 0xf0, 0x39, 0xd4, 0xd1, 0xb9, 0x83, 0x93, 0x01,
	 0x30, 0x10, 0x82, 0x47, 0xa7, 0xf1, 0xfe, 0x44, 0x2c, 0x2b, 0x70, 0xf3, 0xb0, 0x42, 0x59, 0x0c,
	 0xd6, 0x1c, 0x8b, 0x7a, 0x1a, 0x44, 0x88, 0x6c, 0xf4, 0x10, 0x58, 0x80, 0xd3, 0x4b, 0x80, 0xc7,
	 0x83, 0xef, 0x07, 0xae, 0x0f, 0xc0, 0xe4, 0x52, 0x60, 0x7a, 0x54, 0x90, 0xa3, 0x54, 0xab, 0x14,
	 0x15, 0xef, 0xc7, 0xbf, 0x8e, 0xd3, 0xb4, 0x70, 0x47, 0xab, 0x01, 0x7c, 0x74, 0x93, 0x98, 0x16,
	 0x80, 0xef, 0x0e, 0xbf, 0x1c, 0x60, 0x7f, 0xf0, 0xfd, 0xf1, 0x50, 0xfd, 0x98, 0xe5, 0xbb, 0x0b,
	 0x43, 0x60, 0x0a, 0x2c, 0x38, 0x05, 0x23, 0x41, 0x87, 0xec, 0xde, 0x64, 0x80, 0xdc, 0xb0, 0x8c,
	 0x97, 0x2b, 0xea, 0x1f, 0x38, 0xb2, 0x3e, 0x50, 0x80, 0xcd, 0x41, 0xfd, 0xd1, 0x03, 0xa0, 0x24,
	 0x11, 0x74, 0x3f, 0x00, 0x80
};


/****** END FONTS *******/

const u8 G_barril[100] = {
	0x00, 0x55, 0xFF, 0xAA, 0x00,
	0x00, 0xBA, 0xF5, 0xF5, 0x00,
	0x55, 0x70, 0xFA, 0xF0, 0xAA,
	0x55, 0xFF, 0xF0, 0xF5, 0xAA,
	0x55, 0xD5, 0xFF, 0xAE, 0xAA,
	0xBA, 0xEA, 0x0C, 0x18, 0xF5,
	0xFF, 0x75, 0x30, 0xBA, 0xF5,
	0xFA, 0xFF, 0xFA, 0xBA, 0xF5,
	0xFA, 0x75, 0x30, 0xBA, 0xF5,
	0xEA, 0x75, 0xFA, 0xBA, 0x5D,
	0xEA, 0xD5, 0x70, 0xAE, 0x5D,
	0xBA, 0xC0, 0x84, 0x0C, 0xF5,
	0xFA, 0x60, 0x84, 0x18, 0xF5,
	0xFA, 0xFF, 0xFA, 0xBA, 0xF5,
	0xFA, 0x75, 0x70, 0xBA, 0xF5,
	0x55, 0xFF, 0xFA, 0xBA, 0xAA,
	0x55, 0xD5, 0x70, 0xAE, 0xAA,
	0xD5, 0xE0, 0x0C, 0x58, 0xEA,
	0xC0, 0xFF, 0xF0, 0xFF, 0xC0,
	0x40, 0xD5, 0xFF, 0xEA, 0x80};

const u8 G_explosiona[76] = {
	0x00, 0x10, 0x20, 0x00,
	0x00, 0x34, 0x38, 0x00,
	0x00, 0x70, 0xB0, 0x00,
	0x00, 0x6C, 0xB4, 0x00,
	0x00, 0x70, 0xB0, 0x20,
	0x10, 0x78, 0xB0, 0x38,
	0x34, 0xD8, 0xD8, 0x38,
	0x78, 0xE4, 0xE4, 0xB4,
	0x70, 0xD8, 0xD8, 0x98,
	0x6C, 0xCC, 0xCC, 0xB4,
	0x70, 0x0C, 0x0C, 0x98,
	0x6C, 0x0C, 0x0C, 0xB4,
	0x70, 0x0C, 0x0C, 0x98,
	0x6C, 0x0C, 0x0C, 0xB4,
	0x70, 0x0C, 0x0C, 0x98,
	0x34, 0x8C, 0x4C, 0x38,
	0x10, 0xA4, 0x58, 0x20,
	0x10, 0x6C, 0x9C, 0x20,
	0x70, 0x34, 0x38, 0xB0};


const u8 G_explosionb[76] = {
	0x00, 0x10, 0x00, 0x00,
	0x00, 0x14, 0x00, 0x00,
	0x00, 0x50, 0x20, 0x00,
	0x00, 0x64, 0x28, 0x00,
	0x00, 0x6C, 0x20, 0x00,
	0x00, 0x70, 0x28, 0x00,
	0x00, 0x34, 0x20, 0x00,
	0x00, 0x14, 0x00, 0x00,
	0x00, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x14, 0x10, 0x00,
	0x10, 0x00, 0x10, 0x00,
	0x00, 0x24, 0x70, 0x10,
	0x20, 0x8C, 0xD8, 0x20,
	0x78, 0x8C, 0x9C, 0x28,
	0x34, 0xA4, 0xB4, 0x20,
	0x10, 0x78, 0x38, 0x00,
	0x10, 0x6C, 0x38, 0x00,
	0x00, 0x34, 0x20, 0x00};

const u8 G_coke[42] = {
	0x55, 0xFF, 0xAA,
	0xEA, 0xC0, 0xD5,
	0xBE, 0x2C, 0x7D,
	0xBA, 0x2C, 0x75,
	0xBE, 0x2C, 0x7D,
	0xAE, 0x3C, 0x5D,
	0xAE, 0x3C, 0x5D,
	0xBE, 0x1C, 0x5D,
	0xAE, 0x2C, 0x5D,
	0xBE, 0x2C, 0x7D,
	0xAE, 0x2C, 0x7D,
	0xBE, 0x0C, 0x7D,
	0xEA, 0xC0, 0xD5,
	0x55, 0xFF, 0xAA};

const u8 G_dolar[55] = {
	0x00, 0x00, 0xFF, 0x00, 0x00,
	0x00, 0x55, 0x33, 0xFF, 0x00,
	0x00, 0xAE, 0x19, 0x33, 0xAA,
	0x55, 0x67, 0x8E, 0x77, 0xAA,
	0xBB, 0x33, 0x67, 0xBB, 0xAA,
	0xFF, 0xBB, 0x77, 0x19, 0xAA,
	0xEF, 0xDF, 0xBB, 0x19, 0xAA,
	0xEF, 0xCF, 0xEF, 0x4D, 0xAA,
	0xEF, 0xCF, 0xEF, 0x5D, 0x80,
	0xD5, 0xEF, 0xEF, 0xEA, 0x00,
	0x40, 0xD5, 0xFF, 0x80, 0x00};

const u8 G_muro[128] = {
	0x84, 0x5D, 0x84, 0x5D, 0x84, 0x5D, 0x84, 0x5D,
	0xC0, 0x5D, 0xC0, 0x5D, 0xC0, 0x5D, 0xEA, 0x5D,
	0xC0, 0xD5, 0xC0, 0xD5, 0xC0, 0xD5, 0xD5, 0xD5,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x5D, 0xC1, 0xD7, 0x84, 0x5D, 0x91, 0x77, 0x84,
	0x5D, 0xEA, 0xD7, 0xC0, 0x5D, 0xC0, 0x77, 0xC0,
	0xD5, 0xD5, 0xD5, 0xC0, 0xD5, 0xC0, 0xD5, 0xC0,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xC1, 0xD7, 0xC1, 0xD7, 0xC1, 0xD7, 0xC1, 0xD7,
	0xC0, 0xD7, 0xC0, 0xD7, 0xEA, 0xD7, 0xC0, 0xD7,
	0xC0, 0xD5, 0xC0, 0xD5, 0xD5, 0xD5, 0xC0, 0xD5,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xD7, 0x91, 0x77, 0xC1, 0xD7, 0xC1, 0xD7, 0xC1,
	0xD7, 0xEA, 0x77, 0xEA, 0xD7, 0xEA, 0xD7, 0xEA,
	0xC5, 0xD5, 0xC5, 0xD5, 0xC5, 0xD5, 0xC5, 0xD5,
	0x67, 0x67, 0x67, 0x67, 0x67, 0x67, 0x67, 0x67};

const u8 G_botella[39] = {
	0x55, 0xFF, 0x00,
	0x55, 0x7D, 0x00,
	0x55, 0xFF, 0x00,
	0x55, 0xF5, 0x00,
	0x55, 0x7D, 0x00,
	0x55, 0x75, 0x00,
	0xBA, 0xE4, 0xAA,
	0xBA, 0xE4, 0xAA,
	0xEA, 0x0C, 0xAA,
	0xEA, 0x0C, 0xAA,
	0xBA, 0xB4, 0xAA,
	0xBA, 0xB4, 0xAA,
	0xFF, 0xFF, 0xAA};

const u8 G_bala1[8] = {
	0x55, 0xAA,
	0xFA, 0xDD,
	0xFA, 0xF5,
	0x55, 0xAA};


const u8 G_bala2[8] = {
	0x55, 0xAA,
	0xEE, 0x5D,
	0xEE, 0xDD,
	0x55, 0xAA};


const u8 G_mirilla[55] = {
	0x00, 0x55, 0xFF, 0x00, 0x00,
	0x00, 0xAE, 0x24, 0xAA, 0x00,
	0x55, 0x5D, 0x7D, 0x5D, 0x00,
	0xEA, 0xAA, 0xA0, 0xAE, 0xAA,
	0xEA, 0xAA, 0x00, 0xEA, 0xAA,
	0xBA, 0xA0, 0x00, 0xB0, 0xAA,
	0xEA, 0xAA, 0x00, 0xEA, 0xAA,
	0xAE, 0xAA, 0xA0, 0xEA, 0xAA,
	0x55, 0x5D, 0x7D, 0xD5, 0x00,
	0x00, 0xAE, 0x24, 0xAA, 0x00,
	0x00, 0x55, 0xFF, 0x00, 0x00};


const unsigned char G_sangre[70] = {
	0x8D, 0x98, 0x34, 0x8D, 0x88,
	0x0F, 0x30, 0x30, 0x64, 0x0A,
	0x1E, 0xBA, 0xBA, 0xBA, 0x0A,
	0xBA, 0xBA, 0xFF, 0xBE, 0xAA,
	0x1A, 0xFF, 0xFF, 0xBA, 0x0A,
	0xBA, 0xFF, 0xFF, 0xBA, 0xAA,
	0xBE, 0x75, 0xFF, 0x34, 0xAA,
	0x1E, 0x38, 0x30, 0x38, 0x0A,
	0x9C, 0x34, 0x38, 0x38, 0x88,
	0x98, 0xBA, 0x38, 0x25, 0x0A,
	0x9C, 0x1A, 0x30, 0x0F, 0x88,
	0x1A, 0x1A, 0x38, 0x0F, 0x0A,
	0x0F, 0xBA, 0x38, 0xAF, 0x0A,
	0x5F, 0xFF, 0x75, 0xFF, 0x0A};


const unsigned char G_sinSangre[70] = {
	0x8D, 0xCC, 0xCC, 0x8D, 0x88,
	0x0F, 0xCC, 0xCC, 0xCC, 0x0A,
	0x4E, 0x4E, 0xCC, 0xCC, 0x0A,
	0xAF, 0x8D, 0xCC, 0xCC, 0xAA,
	0x0F, 0x4E, 0x4E, 0xCC, 0x0A,
	0xAF, 0x0F, 0x8D, 0xCC, 0xAA,
	0xEE, 0x0F, 0x4E, 0x4E, 0xAA,
	0x0F, 0x8D, 0x0F, 0x8D, 0x0A,
	0xDD, 0x4E, 0x0F, 0x5F, 0x88,
	0x8D, 0xFF, 0xFF, 0xAF, 0x0A,
	0x8D, 0x0F, 0x0F, 0x0F, 0x88,
	0x0F, 0x5F, 0xFF, 0x0F, 0x0A,
	0x0F, 0xFF, 0xFF, 0xAF, 0x0A,
	0x5F, 0xFF, 0xFF, 0xFF, 0x0A};

const u8 G_daniel1[256] = {
	0x00, 0x00, 0x00, 0xAA, 0xAA, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xF5, 0xF5, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x30, 0xF5, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xBA, 0x30, 0xF0, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x60, 0x30, 0x24, 0xF5, 0x00, 0x00,
	0x00, 0x55, 0x30, 0x84, 0x18, 0xF5, 0x00, 0x00,
	0x00, 0x55, 0x30, 0x30, 0x30, 0xF5, 0x00, 0x00,
	0x00, 0x00, 0xBA, 0x30, 0x70, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x70, 0xF5, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xBE, 0x38, 0x3C, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xFE, 0x3C, 0x7D, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x5C, 0xBE, 0xAE, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x5C, 0xBC, 0x06, 0xAA, 0x00, 0x00,
	0x00, 0xAE, 0x5D, 0xFD, 0x06, 0x5D, 0x00, 0x00,
	0x00, 0xAE, 0xD5, 0xA9, 0x06, 0x5D, 0x00, 0x00,
	0x00, 0xAE, 0xFF, 0xA9, 0x42, 0x5D, 0x00, 0x00,
	0x55, 0x48, 0xFF, 0x84, 0x48, 0x0C, 0xAA, 0x00,
	0x55, 0xF0, 0xFF, 0xF7, 0xAE, 0x84, 0xAA, 0x00,
	0x55, 0xF5, 0x51, 0x3F, 0xEA, 0xEA, 0x5D, 0x00,
	0x00, 0xAA, 0xFB, 0x3F, 0xEA, 0xFF, 0xF0, 0xAA,
	0x00, 0x55, 0xB7, 0xF3, 0xF7, 0x7F, 0xF5, 0x00,
	0x00, 0x55, 0xB7, 0xFF, 0xFB, 0x7F, 0xAA, 0x00,
	0x00, 0x55, 0x17, 0xAA, 0xFB, 0x3F, 0xAA, 0x00,
	0x00, 0x55, 0x43, 0xAA, 0x55, 0xB7, 0xAA, 0x00,
	0x00, 0x55, 0x43, 0xAA, 0x55, 0xA3, 0xAA, 0x00,
	0x00, 0x55, 0x43, 0xAA, 0x55, 0x83, 0xAA, 0x00,
	0x00, 0xD5, 0x43, 0xEA, 0x55, 0x83, 0xAA, 0x00,
	0x40, 0xEB, 0x57, 0xF5, 0xD5, 0x83, 0xAA, 0x00,
	0x00, 0xD5, 0x43, 0xEA, 0xD5, 0x83, 0xEA, 0x00,
	0x00, 0x40, 0xFF, 0xC0, 0xFA, 0xAB, 0xD7, 0x80,
	0x00, 0x00, 0xC0, 0xC0, 0xD5, 0x83, 0xEA, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x40, 0xFF, 0x80, 0x00};

const u8 G_daniel2[256] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xAA, 0xAA, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xF5, 0xF5, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x30, 0xF5, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xBA, 0x30, 0xF0, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x60, 0x30, 0x24, 0xF5, 0x00, 0x00,
	0x00, 0x55, 0x30, 0x84, 0x18, 0xF5, 0x00, 0x00,
	0x00, 0x55, 0x30, 0x30, 0x30, 0xF5, 0x00, 0x00,
	0x00, 0x00, 0xBA, 0x30, 0x70, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x70, 0xF5, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xBE, 0x38, 0x3C, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xFE, 0x3C, 0x2C, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x5C, 0xBE, 0xAE, 0xAA, 0x00, 0x00,
	0x00, 0xAE, 0x5C, 0xBC, 0x06, 0x5D, 0x00, 0x00,
	0x00, 0xAE, 0xD5, 0xFD, 0x42, 0x0C, 0xAA, 0x00,
	0x55, 0x48, 0xFF, 0xA9, 0x42, 0x0C, 0xAA, 0x00,
	0x55, 0xF5, 0x55, 0xA9, 0x57, 0xC0, 0xF5, 0x00,
	0x00, 0xAA, 0x55, 0x84, 0x5D, 0xFF, 0xF5, 0x00,
	0x00, 0x00, 0x55, 0xF7, 0xAE, 0xAA, 0xAA, 0x00,
	0x00, 0x00, 0xFB, 0x3F, 0xEA, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0xB7, 0x3F, 0xEA, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0xB7, 0xF3, 0xF7, 0x7F, 0x00, 0x00,
	0x00, 0x55, 0xB7, 0xFF, 0xFB, 0x7F, 0x00, 0x00,
	0x00, 0x55, 0x43, 0xAA, 0xFF, 0xB7, 0xAA, 0x00,
	0x00, 0x55, 0x43, 0xAA, 0x55, 0xA3, 0xAA, 0x00,
	0x00, 0xD5, 0x43, 0xAA, 0x55, 0x83, 0xAA, 0x00,
	0x40, 0xD5, 0x43, 0xEA, 0x55, 0x83, 0xAA, 0x00,
	0x00, 0xEB, 0x57, 0xF5, 0xD5, 0x83, 0xAA, 0x00,
	0x00, 0xD5, 0x43, 0xEA, 0xD5, 0x83, 0xEA, 0x00,
	0x00, 0x40, 0xFF, 0xC0, 0xFA, 0xAB, 0xD7, 0x00,
	0x00, 0x00, 0xC0, 0xC0, 0xD5, 0x83, 0xEA, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x40, 0xFF, 0x80, 0x00};

const u8 G_danielRun1[256] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFA, 0xFA, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xBA, 0x70, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xBA, 0x0C, 0xF5, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x84, 0x30, 0x70, 0xAA, 0x00,
	0x00, 0x00, 0xBA, 0x30, 0x75, 0x30, 0xAA, 0x00,
	0x00, 0x00, 0xBA, 0x75, 0xFA, 0xFF, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xFF, 0xF0, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x7D, 0xCC, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x3C, 0xFF, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xFF, 0x3C, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xEA, 0x5D, 0x7D, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xEA, 0x48, 0x29, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xEA, 0x0C, 0xFE, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x84, 0xFE, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xAE, 0xAE, 0x5D, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xEA, 0xEA, 0x58, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xEA, 0xFB, 0xFA, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xB7, 0xFF, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xB7, 0xFB, 0x7F, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xB7, 0xFB, 0x7F, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xB7, 0xFF, 0x7F, 0x00, 0x00,
	0x00, 0x00, 0xFB, 0x7F, 0xAB, 0x57, 0x00, 0x00,
	0x00, 0x00, 0xFB, 0x57, 0x03, 0xD7, 0x00, 0x00,
	0x00, 0x00, 0xEB, 0x57, 0x43, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xEB, 0x57, 0xD7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xEB, 0x57, 0xD7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xEB, 0x57, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x55, 0xF5, 0x57, 0xC0, 0xC0, 0x00, 0x00,
	0x00, 0x40, 0xEB, 0x43, 0xEA, 0xC0, 0x80, 0x00,
	0x00, 0x00, 0xFF, 0xFF, 0xEA, 0xC0, 0x00, 0x00};


const u8 G_danielRun2[256] = {
	0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x55, 0xF5, 0xF5, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x55, 0x30, 0xF5, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x55, 0x24, 0x58, 0xAA, 0x00,
	0x00, 0x00, 0x00, 0xEA, 0x18, 0x30, 0xF5, 0x00,
	0x00, 0x00, 0x55, 0x30, 0x30, 0xBA, 0x75, 0x00,
	0x00, 0x00, 0x55, 0x30, 0xFF, 0xF5, 0xAA, 0x00,
	0x00, 0x00, 0x00, 0xFF, 0xFA, 0xF5, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xBE, 0xEE, 0xDD, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xBE, 0x7D, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x5D, 0x3C, 0x7D, 0x00, 0x00,
	0x00, 0x00, 0xAE, 0x5C, 0xBE, 0xAE, 0xAA, 0x00,
	0x00, 0x00, 0xAE, 0xD4, 0xBC, 0x06, 0xAA, 0x00,
	0x00, 0x55, 0x0C, 0xFF, 0xFD, 0x06, 0xAA, 0x00,
	0x00, 0x55, 0x48, 0xFF, 0xA9, 0x06, 0x5D, 0x00,
	0x00, 0x55, 0x5D, 0x55, 0xA9, 0x42, 0x0C, 0xAA,
	0x00, 0xFA, 0xAA, 0xAE, 0x84, 0x5D, 0x84, 0xAA,
	0x00, 0xFA, 0xAA, 0xEA, 0xFF, 0xFF, 0xEA, 0xF5,
	0x00, 0x55, 0x00, 0xEA, 0xBF, 0xF7, 0x55, 0xF5,
	0x00, 0x00, 0x00, 0xFF, 0x3F, 0xF7, 0x00, 0xAA,
	0x00, 0x00, 0xAA, 0xFB, 0xB7, 0x7B, 0xAA, 0x00,
	0x00, 0xFF, 0xF5, 0xFF, 0xF3, 0x3F, 0xAA, 0x00,
	0x00, 0xEB, 0xEB, 0xD3, 0xFB, 0xB7, 0xAA, 0x00,
	0x00, 0xAB, 0x03, 0x17, 0x7F, 0xB7, 0xAA, 0x00,
	0x00, 0xAB, 0x03, 0x03, 0xFF, 0xA3, 0xAA, 0x00,
	0x00, 0xEB, 0xFF, 0xFF, 0x55, 0x83, 0xAA, 0x00,
	0x00, 0xFF, 0x00, 0x00, 0x55, 0x83, 0xAA, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x55, 0x83, 0xAA, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x55, 0x83, 0xAA, 0x00,
	0x00, 0x40, 0xC0, 0xC0, 0xFA, 0xAB, 0xEA, 0x80,
	0x00, 0xC0, 0xC0, 0xC0, 0xD5, 0x83, 0xD7, 0xC0,
	0x00, 0x40, 0xC0, 0xC0, 0xD5, 0xFF, 0xFF, 0x80};

const u8 G_danielFireL1[256] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0x00,
	0x00, 0xAA, 0x00, 0xFA, 0xFA, 0xAA, 0x00, 0x00,
	0x55, 0x5D, 0x00, 0xBA, 0x70, 0xAA, 0x00, 0x00,
	0x00, 0xAE, 0xFF, 0x30, 0x70, 0xF5, 0x00, 0x00,
	0x00, 0x55, 0xBA, 0x90, 0x30, 0x58, 0xAA, 0x00,
	0x00, 0x00, 0xBA, 0x60, 0x0C, 0x70, 0xAA, 0x00,
	0x00, 0x00, 0xBA, 0x30, 0x30, 0x70, 0xAA, 0x00,
	0x00, 0x00, 0xFF, 0x30, 0x30, 0xF5, 0x00, 0x00,
	0x00, 0x00, 0xAE, 0xBA, 0xF0, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x3C, 0x34, 0x7D, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xBE, 0x3C, 0x7D, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xAE, 0xBE, 0xFF, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xAE, 0x16, 0x5D, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x0C, 0x57, 0x5D, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x48, 0x03, 0x5D, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x5D, 0x03, 0xFF, 0x00, 0x00,
	0x00, 0x00, 0xAE, 0xD5, 0x0C, 0xD5, 0x00, 0x00,
	0x00, 0x00, 0xFA, 0xF5, 0xFF, 0xFF, 0x00, 0x00,
	0x00, 0x00, 0xFA, 0xFF, 0x3F, 0xF3, 0xAA, 0x00,
	0x00, 0x00, 0x55, 0xBF, 0x3F, 0x3F, 0xAA, 0x00,
	0x40, 0x00, 0x55, 0x3F, 0xF3, 0xB7, 0x7F, 0x00,
	0x40, 0x80, 0xFB, 0x7B, 0xFF, 0xFB, 0x7F, 0x00,
	0x00, 0xC0, 0xFB, 0x7F, 0x00, 0x55, 0xA3, 0xAA,
	0x00, 0x40, 0xAB, 0x7F, 0x00, 0x55, 0x83, 0xAA,
	0x00, 0x00, 0xAB, 0xD7, 0x00, 0x55, 0x83, 0xAA,
	0x00, 0x00, 0xAB, 0xD7, 0x00, 0x55, 0x83, 0xAA,
	0x00, 0x00, 0xAB, 0xD7, 0x80, 0x55, 0x83, 0xAA,
	0x00, 0x40, 0xAB, 0xD7, 0xC0, 0xD5, 0xF5, 0xAA,
	0x00, 0x55, 0x83, 0xFA, 0xEA, 0xD5, 0x83, 0xAA,
	0x00, 0x40, 0xAB, 0xD7, 0xC0, 0xC0, 0xFF, 0x80,
	0x00, 0x00, 0xD5, 0xEA, 0x00, 0xC0, 0xC0, 0x00};

const u8 G_danielFireL2[256] =  {
	0x10, 0x00, 0x00, 0xAA, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x20, 0x55, 0x5D, 0x00, 0x00, 0x00, 0x00,
	0x64, 0x20, 0x55, 0x5D, 0x55, 0x00, 0x00, 0x00,
	0x8C, 0x88, 0x55, 0xFA, 0xFA, 0xAA, 0x00, 0x00,
	0x64, 0x20, 0x55, 0xBA, 0x70, 0xAA, 0x00, 0x00,
	0x70, 0x20, 0x55, 0x30, 0x70, 0xF5, 0x00, 0x00,
	0x10, 0x00, 0xBA, 0x90, 0x30, 0x58, 0xAA, 0x00,
	0x00, 0x00, 0xBA, 0x60, 0x0C, 0x70, 0xAA, 0x00,
	0x00, 0x00, 0xBA, 0x30, 0x30, 0x70, 0xAA, 0x00,
	0x00, 0x00, 0x55, 0x30, 0x30, 0xF5, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xBA, 0xF0, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3C, 0x34, 0x7D, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xBE, 0x3C, 0x7D, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xAE, 0xBE, 0xFF, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xAE, 0x16, 0x5D, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x0C, 0x57, 0x5D, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x48, 0x03, 0x5D, 0x00, 0x00,
	0x00, 0x00, 0xAE, 0x5D, 0x03, 0xFF, 0x00, 0x00,
	0x00, 0x55, 0x48, 0xFF, 0x0C, 0xD5, 0x00, 0x00,
	0x00, 0x55, 0xF5, 0x55, 0xFF, 0xFF, 0x00, 0x00,
	0x00, 0x00, 0xAA, 0xFF, 0x3F, 0xF3, 0xAA, 0x00,
	0x00, 0x00, 0x55, 0xBF, 0x3F, 0x3F, 0xAA, 0x00,
	0x00, 0x00, 0x55, 0x3F, 0xF3, 0xB7, 0x7F, 0x00,
	0x00, 0x00, 0xFB, 0x7B, 0xFF, 0xFB, 0x7F, 0x00,
	0x00, 0x00, 0xFB, 0x7F, 0x00, 0x55, 0xA3, 0xAA,
	0x00, 0x00, 0xAB, 0x7F, 0x00, 0x55, 0x83, 0xAA,
	0x00, 0x00, 0xAB, 0xD7, 0x00, 0x55, 0x83, 0xAA,
	0x00, 0x00, 0xAB, 0xD7, 0x80, 0x55, 0x83, 0xAA,
	0x00, 0x40, 0xAB, 0xD7, 0xC0, 0xD5, 0xF5, 0xAA,
	0x00, 0x55, 0x83, 0xFA, 0xEA, 0xD5, 0x83, 0xAA,
	0x00, 0x40, 0xAB, 0xD7, 0xC0, 0xC0, 0xFF, 0x80,
	0x00, 0x00, 0xD5, 0xEA, 0x00, 0xC0, 0xC0, 0x00};


const u8 G_danielFireC1[256] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xAA, 0xAA, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xF5, 0xF5, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x30, 0xF5, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xBA, 0x30, 0xF0, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x60, 0x30, 0x24, 0xF5, 0x00, 0x00,
	0x00, 0x55, 0x30, 0x84, 0x18, 0xF5, 0x00, 0x00,
	0x00, 0x55, 0x30, 0x30, 0x30, 0xF5, 0x00, 0x00,
	0x00, 0x00, 0xBA, 0x30, 0x70, 0xFF, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x70, 0xF5, 0x5D, 0x00, 0x00,
	0x00, 0x00, 0xBE, 0x38, 0x3C, 0x5D, 0x00, 0x00,
	0x00, 0x00, 0xFF, 0x3C, 0x7D, 0xD5, 0x00, 0x00,
	0x00, 0x00, 0xAE, 0xBE, 0xAE, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xAE, 0xBC, 0x06, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x0C, 0xFD, 0x06, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x48, 0xA9, 0x06, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x5D, 0xA9, 0x06, 0xAA, 0x00, 0x00,
	0x00, 0xAE, 0xD5, 0x84, 0x5D, 0xAA, 0x00, 0x00,
	0x00, 0xFA, 0xF5, 0xF7, 0xEA, 0xAA, 0x00, 0x00,
	0x00, 0xFA, 0xFF, 0x3F, 0xEA, 0xFF, 0x00, 0x00,
	0x00, 0x55, 0x55, 0x3F, 0xF7, 0x7F, 0x00, 0x00,
	0x00, 0x00, 0xBF, 0x7B, 0xF3, 0x3F, 0xAA, 0x00,
	0x00, 0x55, 0xB7, 0xF7, 0xFF, 0xB7, 0xAA, 0x00,
	0x00, 0x55, 0xB7, 0xAA, 0x55, 0xA3, 0xAA, 0x00,
	0x00, 0x55, 0x17, 0xAA, 0x55, 0x83, 0xAA, 0x00,
	0x00, 0x55, 0x43, 0xAA, 0x55, 0x83, 0xAA, 0x00,
	0x00, 0x55, 0x43, 0xAA, 0x55, 0x83, 0xAA, 0x00,
	0x00, 0x55, 0x43, 0xAA, 0xD5, 0x83, 0xAA, 0x00,
	0x00, 0xD5, 0x43, 0xEA, 0xD5, 0xF5, 0xAA, 0x00,
	0x00, 0xEB, 0x57, 0xF5, 0xD5, 0x83, 0xAA, 0x00,
	0x00, 0xD5, 0x43, 0xEA, 0xC0, 0xFF, 0x80, 0x00,
	0x00, 0x40, 0xFF, 0xC0, 0x00, 0xC0, 0x00, 0x00};


const u8 G_danielFireC2[256] ={
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xAA, 0xFF, 0x5D, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xF5, 0xF5, 0x5D, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x30, 0xF5, 0xD5, 0x00, 0x00,
	0x00, 0x00, 0xBA, 0x30, 0xF0, 0xFF, 0x00, 0x00,
	0x00, 0x55, 0x60, 0x30, 0x24, 0xF5, 0x00, 0x00,
	0x00, 0x55, 0x30, 0x84, 0x18, 0xF5, 0x00, 0x00,
	0x00, 0x55, 0x30, 0x30, 0x30, 0xF5, 0x00, 0x00,
	0x00, 0x00, 0xBA, 0x30, 0x70, 0xFF, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x70, 0xF5, 0x5D, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x38, 0x3C, 0x5D, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xBE, 0x7D, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x1C, 0x2C, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x5D, 0x2C, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xAE, 0x09, 0xAE, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xAE, 0x81, 0x06, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xAE, 0xA9, 0x06, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x48, 0x84, 0x5D, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0xF5, 0xF7, 0xEA, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xFF, 0x3F, 0xEA, 0xFF, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x3F, 0xF7, 0x7F, 0x00, 0x00,
	0x00, 0x00, 0xBF, 0x7B, 0xF3, 0x3F, 0xAA, 0x00,
	0x00, 0x55, 0xB7, 0xFF, 0xFF, 0xB7, 0xAA, 0x00,
	0x00, 0x55, 0xB7, 0xAA, 0x55, 0xA3, 0xAA, 0x00,
	0x00, 0x55, 0x17, 0xAA, 0x55, 0x83, 0xAA, 0x00,
	0x00, 0x55, 0x43, 0xAA, 0x55, 0x83, 0xAA, 0x00,
	0x00, 0x55, 0x43, 0xAA, 0xD5, 0x83, 0xAA, 0x00,
	0x00, 0xD5, 0x43, 0xEA, 0xD5, 0xF5, 0xAA, 0x00,
	0x00, 0xEB, 0x57, 0xF5, 0xD5, 0x83, 0xAA, 0x00,
	0x00, 0xD5, 0x43, 0xEA, 0xC0, 0xFF, 0x80, 0x00,
	0x00, 0x40, 0xFF, 0xC0, 0x00, 0xC0, 0x00, 0x00};


const u8 G_danielFireR1[256] ={
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0xFA, 0xFA, 0xAA, 0x00, 0x55, 0x5D,
	0x00, 0x00, 0xBA, 0x70, 0xAA, 0x00, 0xAE, 0xAA,
	0x00, 0x55, 0x30, 0x70, 0xF5, 0x55, 0x5D, 0x00,
	0x00, 0xBA, 0x90, 0x30, 0x58, 0xFF, 0xF0, 0x00,
	0x00, 0xBA, 0x60, 0x0C, 0x70, 0xFF, 0xF5, 0x00,
	0x00, 0xBA, 0x30, 0x30, 0x70, 0xAE, 0xAA, 0x00,
	0x00, 0x55, 0x30, 0x30, 0xF5, 0x0C, 0xAA, 0x00,
	0x00, 0x00, 0xBA, 0xF0, 0xFF, 0x5D, 0x00, 0x00,
	0x00, 0x00, 0x3C, 0x34, 0x2C, 0xD5, 0x00, 0x00,
	0x00, 0x00, 0xBE, 0x3C, 0xAE, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x5D, 0x7D, 0x5D, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x5C, 0x29, 0x5D, 0x00, 0x00, 0x00,
	0x00, 0xAE, 0x5C, 0xAB, 0x5D, 0x00, 0x00, 0x00,
	0x00, 0xAE, 0xD4, 0x03, 0x5D, 0x00, 0x00, 0x00,
	0x00, 0xAE, 0xFE, 0x03, 0xD5, 0x00, 0x00, 0x00,
	0x55, 0x48, 0xEA, 0x0C, 0xFF, 0x00, 0x00, 0x00,
	0x55, 0xF0, 0xFB, 0xFF, 0xD5, 0x00, 0x00, 0x00,
	0x55, 0xF5, 0xBF, 0x7F, 0xD5, 0xAA, 0x00, 0x00,
	0x00, 0xAA, 0xBF, 0x7B, 0xBF, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x3F, 0xF3, 0xB7, 0x7F, 0x00, 0x00,
	0x00, 0xFB, 0x7B, 0xFF, 0xFB, 0x7F, 0x00, 0x00,
	0x00, 0xFB, 0x7F, 0x00, 0x55, 0xA3, 0xAA, 0x00,
	0x00, 0xAB, 0x7F, 0x00, 0x55, 0x83, 0xAA, 0xC0,
	0x00, 0xAB, 0xD7, 0x00, 0x55, 0x83, 0xEA, 0x80,
	0x00, 0xAB, 0xD7, 0x00, 0x55, 0x83, 0xEA, 0x00,
	0x00, 0xAB, 0xD7, 0x00, 0xD5, 0x83, 0xEA, 0x00,
	0x00, 0xAB, 0xD7, 0xC0, 0xFA, 0xAB, 0xD7, 0x00,
	0x00, 0xFF, 0xF5, 0xC0, 0xD5, 0x83, 0xEA, 0x00,
	0x00, 0xAB, 0xD7, 0xC0, 0xC0, 0xFF, 0x80, 0x00,
	0x00, 0xD5, 0xEA, 0x80, 0x40, 0xC0, 0x00, 0x00};


const u8 G_danielFireR2[256] ={
	0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x20,
	0x00, 0x00, 0x00, 0x00, 0xAE, 0xAA, 0x10, 0xB0,
	0x00, 0x00, 0x55, 0x55, 0xAE, 0xAA, 0x10, 0x98,
	0x00, 0x00, 0xFA, 0xFA, 0xAE, 0xAA, 0x44, 0x4C,
	0x00, 0x00, 0xBA, 0x70, 0xEA, 0xF5, 0x10, 0x98,
	0x00, 0x55, 0x30, 0x70, 0xF0, 0xF5, 0x10, 0xB0,
	0x00, 0xBA, 0x90, 0x30, 0x5D, 0x5D, 0x00, 0x20,
	0x00, 0xBA, 0x60, 0x0C, 0x75, 0x5D, 0x00, 0x00,
	0x00, 0xBA, 0x30, 0x30, 0x75, 0xD5, 0x00, 0x00,
	0x00, 0x55, 0x30, 0x30, 0xAE, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xBA, 0xF0, 0xAE, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x3C, 0x34, 0x2C, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xBE, 0x3C, 0xEA, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x5D, 0x7D, 0x5D, 0x00, 0x00, 0x00,
	0x00, 0x55, 0x5C, 0x29, 0x5D, 0x00, 0x00, 0x00,
	0x00, 0xAE, 0x5C, 0xAB, 0x5D, 0x00, 0x00, 0x00,
	0x00, 0xAE, 0xD4, 0x03, 0x5D, 0x00, 0x00, 0x00,
	0x55, 0x48, 0xFE, 0x03, 0xD5, 0x00, 0x00, 0x00,
	0xFA, 0xF5, 0xEA, 0x0C, 0xFF, 0x00, 0x00, 0x00,
	0xFA, 0xAA, 0xFB, 0xFF, 0xD5, 0x00, 0x00, 0x00,
	0x55, 0x00, 0xBF, 0x7F, 0xD5, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xBF, 0x7B, 0xBF, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x3F, 0xF3, 0xB7, 0x7F, 0x00, 0x00,
	0x00, 0xFB, 0x7F, 0xFF, 0xFB, 0x7F, 0x00, 0x00,
	0x00, 0xFB, 0x7F, 0x00, 0xD5, 0xA3, 0xAA, 0x00,
	0x00, 0xAB, 0x7F, 0x00, 0xD5, 0x83, 0xAA, 0x00,
	0x00, 0xAB, 0xD7, 0x00, 0xD5, 0x83, 0xAA, 0x00,
	0x00, 0xAB, 0xD7, 0x40, 0xD5, 0x83, 0xEA, 0x00,
	0x00, 0xAB, 0xD7, 0xC0, 0xFA, 0xAB, 0xD7, 0x00,
	0x00, 0xFF, 0xF5, 0xC0, 0xD5, 0x83, 0xEA, 0x00,
	0x00, 0xAB, 0xD7, 0xC0, 0xC0, 0xFF, 0x80, 0x00,
	0x00, 0xD5, 0xEA, 0x80, 0x40, 0xC0, 0x00, 0x00};

const u8 G_danielMuerte1[256] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xBE, 0xAA, 0x00, 0x20, 0x00,
	0x10, 0x28, 0x55, 0xF5, 0xF5, 0x10, 0x28, 0x00,
	0x00, 0x20, 0x55, 0x30, 0xF5, 0x14, 0x00, 0x00,
	0x10, 0x00, 0xBA, 0x30, 0xF0, 0xBA, 0x00, 0x00,
	0x34, 0x75, 0x60, 0x30, 0x24, 0xF5, 0x00, 0x00,
	0x10, 0x7D, 0x30, 0x84, 0x18, 0xF5, 0x00, 0x00,
	0x00, 0x75, 0x30, 0x30, 0x30, 0xF5, 0x14, 0x00,
	0x00, 0x10, 0xBA, 0x30, 0x70, 0xBA, 0x10, 0x00,
	0x55, 0x34, 0x75, 0x70, 0xF5, 0x34, 0x00, 0x00,
	0xFA, 0xBA, 0xFE, 0x3C, 0x7D, 0x38, 0x00, 0x00,
	0xFA, 0xFF, 0x5C, 0xBE, 0xAE, 0xAA, 0x00, 0x00,
	0x55, 0x1C, 0x5C, 0xBC, 0x06, 0xFF, 0x55, 0x00,
	0x55, 0x84, 0x7D, 0xFD, 0x16, 0x0C, 0xFA, 0xAA,
	0x00, 0xEA, 0xD5, 0xA9, 0x06, 0x0C, 0xF0, 0xAA,
	0x00, 0x55, 0xFF, 0xA9, 0x42, 0x68, 0xFF, 0x00,
	0x00, 0x00, 0x55, 0x84, 0x48, 0x7D, 0x00, 0x00,
	0x00, 0x00, 0xFB, 0xF7, 0xAE, 0xD5, 0x00, 0x00,
	0x00, 0x00, 0xFB, 0x3F, 0xEA, 0xFF, 0x00, 0x00,
	0x00, 0x55, 0xB7, 0x3F, 0xEA, 0xFF, 0x00, 0x00,
	0x00, 0x55, 0xB7, 0xF3, 0xF7, 0x57, 0x00, 0x00,
	0x00, 0xAB, 0x7F, 0xFF, 0xFF, 0x43, 0xAA, 0x00,
	0x00, 0xAB, 0xD7, 0x00, 0xEB, 0x57, 0x00, 0x00,
	0x00, 0xAB, 0xD7, 0x00, 0x55, 0xAA, 0x40, 0x80,
	0x40, 0xAB, 0xD7, 0x00, 0xC0, 0xC0, 0xC0, 0x80,
	0xD5, 0x83, 0xFA, 0xEA, 0xC0, 0xC0, 0x80, 0x00,
	0x40, 0xAB, 0xD7, 0xC0, 0x40, 0xC0, 0x00, 0x00,
	0x40, 0xD5, 0xEA, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


const u8 G_danielMuerte2[256] = {
	0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x20,
	0x10, 0x00, 0x00, 0x14, 0x00, 0x00, 0x10, 0x28,
	0x34, 0x20, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x20, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
	0x00, 0x28, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00,
	0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xEB, 0xAA, 0x00,
	0x00, 0x00, 0xAA, 0x00, 0x55, 0x03, 0xAA, 0x00,
	0x00, 0x55, 0xF7, 0x00, 0xBF, 0x7B, 0xAA, 0x00,
	0x00, 0xBF, 0x7B, 0xAA, 0xBF, 0x7B, 0xAA, 0x00,
	0x00, 0xFB, 0x7B, 0xFF, 0xFB, 0xF3, 0xAA, 0x00,
	0x55, 0xFB, 0xF7, 0xF5, 0xF5, 0xF7, 0x00, 0xAA,
	0xFA, 0xFB, 0xEA, 0xB0, 0xA4, 0xFF, 0x55, 0xF5,
	0xFA, 0xFF, 0x60, 0xB0, 0xA4, 0xF5, 0xAE, 0xF5,
	0xAE, 0xFF, 0x60, 0xB0, 0xA4, 0xF5, 0x48, 0xEA,
	0xEA, 0x5D, 0x60, 0xF0, 0xA4, 0xF5, 0x7D, 0xC0,
	0xD5, 0xD5, 0x60, 0x70, 0x70, 0x30, 0x38, 0x80,
	0x90, 0x7D, 0xBA, 0x84, 0x18, 0xFF, 0x34, 0x20,
	0x34, 0x34, 0xFF, 0xFF, 0xFF, 0x34, 0x30, 0x80,
	0x90, 0x90, 0xC0, 0xC0, 0xC0, 0x90, 0xC0, 0x00,
	0x40, 0x40, 0x40, 0xC0, 0xC0, 0x40, 0x00, 0x00};

const u8 G_cactus[168] = {
	0x00, 0x00, 0x00, 0xAA, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x77, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xBB, 0x9B, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xBB, 0x9B, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xEF, 0x9B, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xBB, 0x9B, 0xFF, 0x00, 0x00,
	0x00, 0x00, 0xEF, 0x9B, 0xBB, 0xAA, 0x00,
	0x00, 0x55, 0xEF, 0x9B, 0xBB, 0xAA, 0x00,
	0x00, 0xBB, 0x77, 0x9B, 0xBB, 0xAA, 0x00,
	0x00, 0xEF, 0x77, 0x9B, 0xBB, 0xAA, 0x00,
	0x00, 0xEF, 0x77, 0x9B, 0xBB, 0xAA, 0x00,
	0x00, 0xEF, 0x77, 0x9B, 0x9B, 0xAA, 0x00,
	0x00, 0xEF, 0x77, 0x9B, 0x9B, 0xAA, 0x00,
	0x00, 0xEF, 0x67, 0x9B, 0x9B, 0xAA, 0x00,
	0x00, 0xEF, 0x67, 0x9B, 0xFF, 0x00, 0x00,
	0x00, 0x55, 0xEF, 0x9B, 0xAA, 0x00, 0x00,
	0x00, 0xAA, 0xEF, 0x9B, 0xAA, 0xAA, 0x00,
	0x55, 0x77, 0xBB, 0x9B, 0xFF, 0x77, 0x00,
	0x55, 0xEF, 0xFF, 0x9B, 0xEF, 0xFF, 0x00,
	0xBB, 0xFF, 0x0C, 0x9B, 0xFF, 0xBB, 0xAA,
	0x55, 0xAE, 0x0C, 0x9B, 0xAE, 0xFF, 0x00,
	0xDF, 0x84, 0x48, 0xFF, 0x84, 0x5D, 0xCF,
	0x00, 0xEA, 0xD5, 0x77, 0x62, 0xAA, 0x00,
	0x45, 0xDF, 0xFF, 0xEF, 0xFF, 0xCF, 0x00};

/******** STATIC SPRITES ***********/

const u8 G_muromadera[128] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFA, 0xF0, 0xF0, 0xF0, 0xF0, 0xE4, 0xE4, 0xDD,
	0xFA, 0x75, 0x75, 0x30, 0x30, 0x30, 0xBA, 0xDD,
	0xFF, 0xB0, 0xB0, 0x75, 0x70, 0x70, 0x30, 0xF5,
	0xEE, 0x30, 0xBA, 0xB0, 0x75, 0x75, 0x70, 0xFF,
	0xFA, 0x70, 0xBA, 0xBA, 0x30, 0x75, 0x30, 0xDD,
	0xFA, 0x75, 0xDD, 0x30, 0x98, 0xEE, 0xBA, 0xF5,
	0xFF, 0xF5, 0xDD, 0xF0, 0xFA, 0xEE, 0xEE, 0xFF,
	0xEE, 0x75, 0xDD, 0x30, 0x75, 0xEE, 0xFF, 0xDD,
	0xFA, 0xFF, 0xF5, 0xB0, 0xBA, 0xFA, 0xFA, 0xF5,
	0xFF, 0xF5, 0xDD, 0xFF, 0x75, 0xEE, 0xFF, 0xF5,
	0xEE, 0xFF, 0xF5, 0xBA, 0xBA, 0xFA, 0xFF, 0xFF,
	0xFF, 0xFF, 0xF5, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF,
	0xFF, 0xDD, 0xF5, 0xDD, 0xEE, 0xFA, 0xEE, 0xFF,
	0xFF, 0xF5, 0xF5, 0xF5, 0xFA, 0xFA, 0xFA, 0xFF,
	0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA};


const u8 G_muropiedra[128] = {
	0x00, 0x00, 0x00, 0x55, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xFF, 0xAE, 0x48, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x0C, 0x0C, 0x0C, 0xD5, 0x00, 0x00,
	0x00, 0xAE, 0x0C, 0x0C, 0x5D, 0xC0, 0xFF, 0x00,
	0x00, 0xAE, 0x0C, 0x0C, 0x0C, 0xFF, 0x84, 0xAA,
	0x55, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x48, 0xAA,
	0x55, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xD5,
	0xFF, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xD5,
	0xEA, 0x84, 0x0C, 0x0C, 0x0C, 0x0C, 0x48, 0xD5,
	0xEA, 0x48, 0x0C, 0x38, 0x0C, 0x0C, 0x84, 0xFF,
	0xFF, 0x84, 0x84, 0x34, 0x0C, 0x48, 0x48, 0xD5,
	0xEA, 0xEA, 0x4D, 0x3C, 0x8E, 0x38, 0xC0, 0xFF,
	0xFF, 0xD5, 0xC0, 0x67, 0xC5, 0x34, 0xD5, 0xD5,
	0xFF, 0xEF, 0x6D, 0xDF, 0xFF, 0x67, 0xFF, 0xAA,
	0x11, 0xBB, 0xDF, 0x77, 0x77, 0xDF, 0x77, 0x22,
	0x8A, 0x77, 0xDF, 0x9B, 0xFF, 0xDF, 0xBB, 0x45};


/********** END STATIC SPRITES ********/

/********** ENEMIES ******************/

const u8 G_malo_lejos_drch1[120] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x55, 0xAA, 0xAA, 0x00, 0x00,
	0x00, 0xBA, 0xF5, 0xF5, 0x00, 0x00,
	0x00, 0xAE, 0x30, 0x5D, 0x00, 0x00,
	0x55, 0xF0, 0x0C, 0xF0, 0xAA, 0x00,
	0x55, 0x30, 0xF0, 0xF5, 0x00, 0x00,
	0x00, 0xFA, 0x30, 0xAA, 0x00, 0x00,
	0x00, 0xBA, 0xCC, 0xAA, 0x00, 0x00,
	0x00, 0xBE, 0x30, 0xAA, 0x00, 0x00,
	0x55, 0x32, 0x3C, 0x75, 0x00, 0x00,
	0x55, 0x33, 0x34, 0x77, 0x00, 0x00,
	0xBB, 0x9B, 0x32, 0x77, 0x00, 0x00,
	0xBB, 0xCA, 0xFC, 0xB9, 0xAA, 0x00,
	0xBA, 0x8E, 0x43, 0x12, 0xF5, 0x00,
	0xFA, 0x24, 0xE9, 0xFC, 0xAA, 0x00,
	0x55, 0xA9, 0xD6, 0xD7, 0x00, 0x00,
	0x00, 0xFB, 0x7B, 0x7F, 0x00, 0x00,
	0x00, 0xFB, 0x7B, 0x7F, 0x00, 0x00,
	0x00, 0xFB, 0x3F, 0xB7, 0xAA, 0x00,
	0xC0, 0xFF, 0xFF, 0xFF, 0xEA, 0x00};


const u8 G_malo_lejos_drch2[120] = {
	0x00, 0x00, 0x55, 0xAA, 0xAA, 0x00,
	0x00, 0x00, 0xBA, 0xF5, 0xF5, 0x00,
	0x00, 0x00, 0xAE, 0x30, 0x5D, 0x00,
	0x00, 0x55, 0xF0, 0x0C, 0xF0, 0xAA,
	0x00, 0x55, 0x30, 0xF0, 0xF5, 0x00,
	0x00, 0x00, 0xFA, 0x30, 0xAA, 0x00,
	0x00, 0xFF, 0x9A, 0xCC, 0xAA, 0x00,
	0x55, 0x33, 0x9E, 0x30, 0xAA, 0xAA,
	0xFA, 0xFF, 0x9A, 0x3C, 0x75, 0xF5,
	0x55, 0x00, 0xBB, 0x34, 0x9B, 0xAA,
	0x00, 0x00, 0xBB, 0x32, 0xDF, 0x00,
	0x00, 0x00, 0xFE, 0xFC, 0xAA, 0x00,
	0x00, 0x55, 0x09, 0xC3, 0xAA, 0xAA,
	0x00, 0xAE, 0xFC, 0xD6, 0x7F, 0x7F,
	0x00, 0xFB, 0xE3, 0xFD, 0xB7, 0xF7,
	0x55, 0xB7, 0xB7, 0xAA, 0xFB, 0xAA,
	0x55, 0x7F, 0x7F, 0x00, 0x55, 0x00,
	0x00, 0xAA, 0xAA, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0};


const u8 G_malo_lejos_izq1[120] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x55, 0xAA, 0x00,
	0x00, 0x00, 0xFA, 0xFA, 0x75, 0x00,
	0x00, 0x00, 0xAE, 0x30, 0x5D, 0x00,
	0x00, 0x55, 0xF0, 0x0C, 0xF0, 0xAA,
	0x00, 0x00, 0xFA, 0xF0, 0x30, 0xAA,
	0x00, 0x00, 0x55, 0x30, 0xF5, 0x00,
	0x00, 0x00, 0x55, 0xCC, 0x75, 0x00,
	0x00, 0x00, 0x55, 0x30, 0x7D, 0x00,
	0x00, 0x00, 0xBA, 0x3C, 0x31, 0xAA,
	0x00, 0x00, 0xBB, 0x38, 0x33, 0xAA,
	0x00, 0x00, 0xBB, 0x31, 0x67, 0x77,
	0x00, 0x55, 0x76, 0xFC, 0xC5, 0x77,
	0x00, 0xFA, 0x21, 0x83, 0x4D, 0x75,
	0x00, 0x55, 0xFC, 0xD6, 0x18, 0xF5,
	0x00, 0x00, 0xEB, 0xE9, 0x56, 0xAA,
	0x00, 0x00, 0xBF, 0xB7, 0xF7, 0x00,
	0x00, 0x00, 0xBF, 0xB7, 0xF7, 0x00,
	0x00, 0x55, 0x7B, 0x3F, 0xF7, 0x00,
	0x00, 0xD5, 0xFF, 0xFF, 0xFF, 0xC0};


const u8 G_malo_lejos_izq2[120] = {
	0x00, 0x55, 0x55, 0xAA, 0x00, 0x00,
	0x00, 0xFA, 0xFA, 0x75, 0x00, 0x00,
	0x00, 0xAE, 0x30, 0x5D, 0x00, 0x00,
	0x55, 0xF0, 0x0C, 0xF0, 0xAA, 0x00,
	0x00, 0xFA, 0xF0, 0x30, 0xAA, 0x00,
	0x00, 0x55, 0x30, 0xF5, 0x00, 0x00,
	0x00, 0x55, 0xCC, 0x65, 0xFF, 0x00,
	0x55, 0x55, 0x30, 0x6D, 0x33, 0xAA,
	0xFA, 0xBA, 0x3C, 0x65, 0xFF, 0xF5,
	0x55, 0x67, 0x38, 0x77, 0x00, 0xAA,
	0x00, 0xEF, 0x31, 0x77, 0x00, 0x00,
	0x00, 0x55, 0xFC, 0xFD, 0x00, 0x00,
	0x55, 0x55, 0xC3, 0x06, 0xAA, 0x00,
	0xBF, 0xBF, 0xE9, 0xFC, 0x5D, 0x00,
	0xFB, 0x7B, 0xFE, 0xD3, 0xF7, 0x00,
	0x55, 0xF7, 0x55, 0x7B, 0x7B, 0xAA,
	0x00, 0xAA, 0x00, 0xBF, 0xBF, 0xAA,
	0x00, 0x00, 0x00, 0x55, 0x55, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0};


const u8 G_malo_lejos_disp1[120] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xFF, 0x55, 0x00, 0x00,
	0x00, 0x55, 0x70, 0xFA, 0xAA, 0x00,
	0x00, 0x55, 0x18, 0x24, 0xAA, 0x00,
	0x00, 0xFA, 0xA4, 0x58, 0xF5, 0x00,
	0x00, 0xBA, 0xF0, 0xF0, 0x75, 0x00,
	0x00, 0x55, 0x30, 0x30, 0xAA, 0x00,
	0x00, 0x55, 0x6C, 0x9C, 0xAA, 0x00,
	0x00, 0xEF, 0x34, 0x38, 0xDF, 0x00,
	0x00, 0xBB, 0x9A, 0xC5, 0x77, 0x00,
	0x00, 0x55, 0x32, 0x18, 0x77, 0x00,
	0x00, 0x55, 0x70, 0x58, 0xAA, 0x00,
	0x00, 0x55, 0x12, 0x12, 0xAA, 0x00,
	0x00, 0x55, 0xA9, 0x56, 0xAA, 0x00,
	0x00, 0x55, 0xD6, 0xE9, 0xAA, 0x00,
	0x00, 0xBF, 0xF7, 0xFB, 0x7F, 0x00,
	0x00, 0xBF, 0xAA, 0x55, 0x7F, 0x00,
	0x55, 0x7B, 0xAA, 0x55, 0xB7, 0xAA,
	0x55, 0xFF, 0xC0, 0xC0, 0xFF, 0xAA};


const u8 G_malo_lejos_disp2[120] = {
	0x00, 0x00, 0x00, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xFF, 0x5D, 0x00, 0x00,
	0x00, 0x55, 0x75, 0x5D, 0xAA, 0x00,
	0x00, 0x55, 0x18, 0x90, 0xAA, 0x00,
	0x00, 0xFA, 0x70, 0x70, 0x75, 0x00,
	0x00, 0x55, 0x32, 0x30, 0x77, 0x00,
	0x00, 0xBB, 0xCF, 0x65, 0x75, 0x00,
	0x00, 0xEF, 0x9A, 0x38, 0xAA, 0x00,
	0x00, 0x55, 0x9A, 0xB0, 0xAA, 0x00,
	0x00, 0x10, 0x34, 0x9C, 0x30, 0x00,
	0x00, 0x34, 0xE4, 0x4C, 0xB4, 0x20,
	0x00, 0x10, 0x34, 0x9C, 0x30, 0x00,
	0x00, 0x55, 0x12, 0xB0, 0xAA, 0x00,
	0x00, 0x55, 0xB8, 0x38, 0xAA, 0x00,
	0x00, 0x55, 0xD6, 0x61, 0xAA, 0x00,
	0x00, 0xBF, 0xF7, 0xFB, 0x7F, 0x00,
	0x00, 0xBF, 0xAA, 0x55, 0x7F, 0x00,
	0x55, 0x7B, 0xAA, 0x55, 0xB7, 0xAA,
	0x55, 0x7F, 0x00, 0x00, 0xBF, 0xAA,
	0x55, 0xFF, 0xC0, 0xC0, 0xFF, 0xAA};

const u8 G_malo_lejos_muerte1[120] = {
	0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x38, 0x00, 0x00,
	0x00, 0x10, 0xBA, 0x38, 0x28, 0x00,
	0x00, 0x34, 0x30, 0x30, 0x30, 0x00,
	0x00, 0x34, 0x38, 0x38, 0x34, 0x20,
	0x00, 0xBE, 0x38, 0x30, 0x3C, 0x20,
	0x00, 0x38, 0x38, 0x38, 0x38, 0x00,
	0x00, 0x75, 0x34, 0x34, 0x70, 0xAA,
	0x00, 0x55, 0x34, 0x38, 0xFA, 0xAA,
	0x55, 0x6D, 0x30, 0x34, 0xDF, 0x00,
	0xFA, 0x31, 0x9A, 0x6D, 0x77, 0x00,
	0x55, 0xFF, 0x38, 0x38, 0x77, 0x00,
	0x00, 0x55, 0x34, 0x34, 0xBF, 0xAA,
	0x00, 0xFF, 0x83, 0x43, 0xBF, 0xAA,
	0x55, 0x7F, 0xE9, 0x56, 0xBF, 0xAA,
	0xBF, 0x7F, 0x54, 0xA8, 0xBF, 0xAA,
	0x55, 0xAA, 0x00, 0x00, 0x55, 0x00,
	0x40, 0xC0, 0xC0, 0xC0, 0xC0, 0x80,
	0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


const u8 G_malo_lejos_muerte2[120] = {
	0x00, 0x00, 0x00, 0x20, 0x14, 0x00,
	0x00, 0x20, 0x10, 0x38, 0x10, 0x00,
	0x10, 0x38, 0x00, 0x20, 0x00, 0x30,
	0x10, 0x38, 0x14, 0x00, 0x10, 0x38,
	0x00, 0x20, 0x10, 0x00, 0x00, 0x20,
	0x00, 0x00, 0x00, 0x28, 0x28, 0x00,
	0x00, 0x14, 0x00, 0x20, 0x20, 0x00,
	0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xAA, 0xFF, 0x00, 0x00,
	0x00, 0x55, 0xF5, 0xB0, 0xAA, 0x00,
	0x00, 0x55, 0x18, 0x24, 0xAA, 0x00,
	0x00, 0x6D, 0x30, 0x34, 0xDF, 0x00,
	0x00, 0x31, 0x9A, 0x6D, 0x77, 0xAA,
	0x55, 0xFF, 0x38, 0x38, 0x77, 0xF5,
	0xFA, 0xFF, 0x34, 0x34, 0xBF, 0xAA,
	0xFF, 0xFF, 0x83, 0x69, 0xBF, 0xAA,
	0xBF, 0xF7, 0xE9, 0x7C, 0xBF, 0xAA,
	0xBF, 0x7F, 0xD4, 0xBC, 0xBF, 0xAA,
	0xD5, 0xEA, 0xC0, 0x94, 0xD5, 0x80,
	0x40, 0xC0, 0xC0, 0xC0, 0xC0, 0x00};


const u8 G_malo_ventana1[100] = {
	0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x55, 0x55, 0x00, 0x00,
	0x00, 0xFA, 0xFA, 0xAA, 0x00,
	0x00, 0xBA, 0xF0, 0xFF, 0x00,
	0x55, 0x18, 0x30, 0x5D, 0x00,
	0xBA, 0x24, 0x0C, 0x70, 0xAA,
	0xBA, 0xB0, 0x30, 0xF0, 0xAA,
	0x55, 0x70, 0xF0, 0xB0, 0x00,
	0x55, 0x30, 0x30, 0x75, 0x00,
	0x55, 0x70, 0xCC, 0x75, 0x00,
	0x55, 0x30, 0x98, 0x65, 0xAA,
	0xEF, 0x38, 0x30, 0x39, 0xDF,
	0xBB, 0x34, 0x3C, 0x39, 0xDF,
	0xEF, 0x9A, 0x3C, 0x65, 0xDF,
	0xEF, 0x67, 0x60, 0x9B, 0xDF,
	0x55, 0x9B, 0x24, 0x65, 0xAA,
	0x00, 0xBA, 0xA4, 0xB0, 0xAA,
	0x00, 0x55, 0x24, 0x75, 0x00,
	0x00, 0x00, 0xFF, 0xAA, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00};


const u8 G_malo_ventana2[100] = {
	0x00, 0x55, 0x55, 0x00, 0x00,
	0x00, 0xFA, 0xFA, 0xAA, 0x00,
	0x00, 0xBA, 0xF0, 0xAA, 0x00,
	0x55, 0x18, 0x30, 0x5D, 0x00,
	0xBA, 0x24, 0x0C, 0x70, 0xAA,
	0xBA, 0xB0, 0x30, 0xF0, 0xAA,
	0x55, 0x70, 0xA4, 0xB0, 0x00,
	0x55, 0x30, 0x24, 0x30, 0x00,
	0x55, 0x30, 0x24, 0x30, 0x00,
	0x55, 0x30, 0xB0, 0x67, 0xAA,
	0xEF, 0x9B, 0x30, 0x9B, 0xDF,
	0xEF, 0x67, 0x9A, 0xCF, 0xDF,
	0xEF, 0xCF, 0x34, 0x65, 0xAA,
	0x55, 0xCF, 0x70, 0x65, 0xAA,
	0x00, 0x30, 0x6C, 0x38, 0x20,
	0x10, 0x78, 0x8C, 0xD8, 0x38,
	0x00, 0x30, 0x6C, 0x38, 0x20,
	0x00, 0x00, 0x70, 0x20, 0x00,
	0x00, 0x00, 0x34, 0x20, 0x00,
	0x00, 0x00, 0x10, 0x00, 0x00};

const u8 G_malo_ventana_muerte2[100] = {
	0x00, 0x00, 0x30, 0x00, 0x00,
	0x00, 0x10, 0x3C, 0x20, 0x00,
	0x10, 0x10, 0x3C, 0x20, 0x00,
	0x34, 0x30, 0x38, 0x00, 0x28,
	0x34, 0x20, 0x20, 0x28, 0x00,
	0x10, 0x00, 0x00, 0x20, 0x00,
	0x00, 0x28, 0x00, 0x00, 0x28,
	0x00, 0x20, 0x14, 0x14, 0x20,
	0x10, 0x00, 0x30, 0x38, 0x00,
	0x34, 0x30, 0x38, 0x60, 0xAA,
	0x10, 0x90, 0x30, 0x75, 0xD7,
	0xEB, 0xBA, 0x38, 0xAE, 0xF5,
	0xFF, 0xF0, 0x34, 0x75, 0xF5,
	0x55, 0xF5, 0x10, 0x00, 0xAA,
	0x00, 0xBE, 0x20, 0x28, 0x00,
	0x00, 0x10, 0x00, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x00,
	0x00, 0x28, 0x28, 0x34, 0x20,
	0x00, 0x20, 0x00, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00};


const u8 G_malo_cerca_drch1[232] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x55, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x55, 0xF0, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xAE, 0x30, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x30, 0x0C, 0x75, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x70, 0x30, 0xF5, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xBA, 0xF0, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xEE, 0x30, 0xAA, 0x00, 0xAA,
	0x00, 0x00, 0x55, 0x1A, 0xD8, 0xAA, 0x55, 0x5D,
	0x00, 0x00, 0xEE, 0x34, 0x75, 0x00, 0xAE, 0xAA,
	0x00, 0x55, 0xCC, 0x34, 0x3C, 0xAA, 0xFA, 0xAA,
	0x00, 0x55, 0x8D, 0x98, 0x38, 0x5F, 0x5F, 0x00,
	0x00, 0xEE, 0x0F, 0x4E, 0x6C, 0x8D, 0xDD, 0x00,
	0x00, 0xFA, 0xAF, 0x4E, 0x64, 0x4E, 0xDD, 0x00,
	0x00, 0xFA, 0xAF, 0xCC, 0x8D, 0xEE, 0xAA, 0x00,
	0x00, 0x55, 0x55, 0x4E, 0xDD, 0x55, 0x00, 0x00,
	0x00, 0x55, 0x55, 0x8D, 0x5F, 0x00, 0x00, 0x00,
	0x00, 0xFA, 0xFA, 0xFC, 0xFD, 0x00, 0x00, 0x00,
	0x55, 0x7F, 0xEA, 0xEF, 0xDE, 0xAA, 0x00, 0x00,
	0xBF, 0xB7, 0xDF, 0x9B, 0x33, 0xAA, 0x00, 0x00,
	0xBF, 0xFB, 0xCF, 0x76, 0xED, 0x77, 0x00, 0x00,
	0x55, 0x55, 0x9B, 0xFF, 0xFE, 0xDF, 0x00, 0x00,
	0x00, 0x00, 0xFF, 0x00, 0x55, 0xDF, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x55, 0x7F, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x55, 0x7F, 0x00, 0x00,
	0x40, 0xC0, 0x00, 0x00, 0xFA, 0xF7, 0x00, 0x80,
	0xC0, 0xC0, 0xC0, 0xC0, 0xD5, 0x3F, 0xEA, 0x80,
	0xC0, 0xC0, 0xC0, 0xC0, 0xD5, 0xFF, 0xEA, 0x00,
	0x00, 0x40, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00};


const u8 G_malo_cerca_drch2[232] = {
	0x00, 0x00, 0x00, 0x55, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x55, 0xF0, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xAE, 0x30, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x30, 0x0C, 0x75, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x70, 0x30, 0xF5, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xBA, 0xF0, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xEE, 0x30, 0xAA, 0x00, 0xAA,
	0x00, 0x00, 0xFF, 0x1A, 0xD8, 0xAA, 0x55, 0x5D,
	0x00, 0x55, 0xCC, 0x34, 0x75, 0x00, 0xAE, 0xAA,
	0x00, 0xEE, 0x8D, 0x34, 0x3C, 0xAA, 0xFA, 0xAA,
	0x00, 0xAF, 0xAF, 0x98, 0x38, 0x5F, 0x5F, 0x00,
	0x55, 0xF5, 0x55, 0x4E, 0x6C, 0x8D, 0xDD, 0x00,
	0x55, 0xF5, 0x55, 0x4E, 0x64, 0x4E, 0xDD, 0x00,
	0x00, 0xAA, 0x55, 0xCC, 0x8D, 0xEE, 0xAA, 0x00,
	0x00, 0x00, 0x55, 0x4E, 0xDD, 0x55, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x8D, 0x5F, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xFA, 0xFC, 0xFD, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xEA, 0xEF, 0xDF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xCF, 0x67, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x9B, 0xED, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x9B, 0xB9, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x76, 0x77, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xEF, 0x77, 0xAA, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xBF, 0xAA, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xBF, 0xAA, 0x00, 0x00, 0x00, 0x80,
	0x00, 0x55, 0xF1, 0xAA, 0x00, 0x40, 0xC0, 0x80,
	0x00, 0xC0, 0xBF, 0x7F, 0xC0, 0xC0, 0xC0, 0x00,
	0x40, 0xC0, 0xFF, 0xFF, 0xC0, 0xC0, 0xC0, 0x00,
	0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x00};


const u8 G_malo_cerca_izq1[232] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFF, 0xAA, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xF0, 0xAA, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x30, 0x5D, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xBA, 0x0C, 0x30, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xFA, 0x30, 0xB0, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xF0, 0x75, 0x00, 0x00, 0x00,
	0x55, 0x00, 0x55, 0x30, 0xDD, 0x00, 0x00, 0x00,
	0xAE, 0xAA, 0x55, 0xE4, 0x25, 0xAA, 0x00, 0x00,
	0x55, 0x5D, 0x00, 0xBA, 0x38, 0xDD, 0x00, 0x00,
	0x55, 0xF5, 0x55, 0x3C, 0x38, 0xCC, 0xAA, 0x00,
	0x00, 0xAF, 0xAF, 0x34, 0x64, 0x4E, 0xAA, 0x00,
	0x00, 0xEE, 0x4E, 0x9C, 0x8D, 0x0F, 0xDD, 0x00,
	0x00, 0xEE, 0x8D, 0x98, 0x8D, 0x1A, 0xF5, 0x00,
	0x00, 0x55, 0xDD, 0x4E, 0xCC, 0x5F, 0xF5, 0x00,
	0x00, 0x00, 0xAA, 0xEE, 0x8D, 0xAA, 0xAA, 0x00,
	0x00, 0x00, 0x00, 0xAF, 0x4E, 0xAA, 0xAA, 0x00,
	0x00, 0x00, 0x00, 0xFE, 0xFC, 0xF5, 0xF5, 0x00,
	0x00, 0x00, 0x55, 0xED, 0xDF, 0xD5, 0xBF, 0xAA,
	0x00, 0x00, 0x55, 0x33, 0x67, 0xEF, 0x7B, 0x7F,
	0x00, 0x00, 0xBB, 0xDE, 0xB9, 0xCF, 0xF7, 0x7F,
	0x00, 0x00, 0xEF, 0xFD, 0xFF, 0x67, 0xAA, 0xAA,
	0x00, 0x00, 0xEF, 0xAA, 0x00, 0xFF, 0x00, 0x00,
	0x00, 0x00, 0xBF, 0xAA, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xBF, 0xAA, 0x00, 0x00, 0x00, 0x00,
	0x40, 0x00, 0xFB, 0xF5, 0x00, 0x00, 0xC0, 0x80,
	0x40, 0xD5, 0x3F, 0xEA, 0xC0, 0xC0, 0xC0, 0xC0,
	0x00, 0xD5, 0xFF, 0xEA, 0xC0, 0xC0, 0xC0, 0xC0,
	0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x00};


const u8 G_malo_cerca_izq2[232] = {
	0x00, 0x00, 0x00, 0xFF, 0xAA, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xF0, 0xAA, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x30, 0x5D, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xBA, 0x0C, 0x30, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xFA, 0x30, 0xB0, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xF0, 0x75, 0x00, 0x00, 0x00,
	0x55, 0x00, 0x55, 0x30, 0xDD, 0x00, 0x00, 0x00,
	0xAE, 0xAA, 0x55, 0xE4, 0x25, 0xFF, 0x00, 0x00,
	0x55, 0x5D, 0x00, 0xBA, 0x38, 0xCC, 0xAA, 0x00,
	0x55, 0xF5, 0x55, 0x3C, 0x38, 0x4E, 0xDD, 0x00,
	0x00, 0xAF, 0xAF, 0x34, 0x64, 0x5F, 0x5F, 0x00,
	0x00, 0xEE, 0x4E, 0x9C, 0x8D, 0xAA, 0xFA, 0xAA,
	0x00, 0xEE, 0x8D, 0x98, 0x8D, 0xAA, 0xFA, 0xAA,
	0x00, 0x55, 0xDD, 0x4E, 0xCC, 0xAA, 0x55, 0x00,
	0x00, 0x00, 0xAA, 0xEE, 0x8D, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xAF, 0x4E, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFE, 0xFC, 0xF5, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xEF, 0xDF, 0xD5, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x9B, 0xCF, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xDE, 0x67, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x76, 0x67, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xBB, 0xB9, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x55, 0xBB, 0xDF, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x55, 0x7F, 0x00, 0x00,
	0x40, 0x00, 0x00, 0x00, 0x55, 0x7F, 0x00, 0x00,
	0x40, 0xC0, 0x80, 0x00, 0x55, 0xF2, 0xAA, 0x00,
	0x00, 0xC0, 0xC0, 0xC0, 0xBF, 0x7F, 0xC0, 0x00,
	0x00, 0xC0, 0xC0, 0xC0, 0xFF, 0xFF, 0xC0, 0x80,
	0x00, 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00};


const u8 G_malo_cerca_disp1[232] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFA, 0xF5, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x18, 0x24, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xBA, 0x24, 0x18, 0x75, 0x00, 0x00,
	0x00, 0x00, 0xBA, 0xB0, 0x70, 0x75, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x70, 0xB0, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xB0, 0x70, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x64, 0x98, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x38, 0x3C, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xEE, 0x3C, 0x38, 0x0A, 0x00, 0x00,
	0x00, 0x00, 0xEE, 0x34, 0x25, 0xDD, 0x00, 0x00,
	0x00, 0x55, 0x8D, 0x1E, 0x4E, 0xDD, 0x00, 0x00,
	0x00, 0xFA, 0x5F, 0x1A, 0xDD, 0xDD, 0x00, 0x00,
	0x00, 0xFA, 0xAA, 0xAF, 0xEA, 0xFF, 0x00, 0x00,
	0x00, 0x55, 0x00, 0xEE, 0xAE, 0xFF, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xAF, 0xAE, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xFA, 0xFE, 0xFF, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xEA, 0xED, 0xDE, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x67, 0x67, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xBB, 0xDE, 0xB9, 0xFD, 0x00, 0x00,
	0x00, 0x00, 0xEF, 0xFD, 0xBB, 0xDF, 0x00, 0x00,
	0x00, 0x00, 0xEF, 0xAA, 0x55, 0x77, 0x00, 0x00,
	0x00, 0x00, 0xBF, 0xAA, 0x55, 0x77, 0x00, 0x00,
	0x00, 0x00, 0xBF, 0xAA, 0x00, 0xBF, 0xAA, 0x00,
	0x00, 0x00, 0xFB, 0xF5, 0x00, 0xBF, 0xAA, 0x00,
	0x00, 0x55, 0x3F, 0xEA, 0xC0, 0xFB, 0xAA, 0x00,
	0x00, 0xD5, 0xFF, 0xEA, 0xC0, 0xBF, 0xAA, 0x00,
	0x00, 0x40, 0xC0, 0xC0, 0xC0, 0xFF, 0xAA, 0x00};


const u8 G_malo_cerca_disp2[232] = {
	0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFA, 0xF5, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x18, 0x24, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0xBA, 0x24, 0x18, 0x75, 0x00, 0x00,
	0x00, 0x00, 0xBA, 0xB0, 0x70, 0x75, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x70, 0xF5, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xB0, 0xAE, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x64, 0xAE, 0xAA, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x38, 0x70, 0x20, 0x00, 0x00,
	0x00, 0x00, 0xEE, 0x3C, 0x6C, 0x5F, 0x00, 0x00,
	0x00, 0xFF, 0x8D, 0x34, 0x25, 0x5F, 0x00, 0x00,
	0x55, 0xF5, 0x0F, 0x1E, 0x0F, 0xDD, 0x00, 0x00,
	0x55, 0xF5, 0xFF, 0x1A, 0x98, 0x5F, 0x00, 0x00,
	0x00, 0xAA, 0x00, 0xAF, 0x34, 0x75, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xEE, 0x70, 0x75, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x30, 0x6C, 0x38, 0x20, 0x00,
	0x00, 0x00, 0xBA, 0x78, 0x8C, 0xD8, 0x38, 0x00,
	0x00, 0x00, 0xEA, 0x30, 0x6C, 0x38, 0x20, 0x00,
	0x00, 0x00, 0x55, 0x67, 0x70, 0x20, 0x00, 0x00,
	0x00, 0x00, 0xBB, 0xDE, 0x34, 0x75, 0x00, 0x00,
	0x00, 0x00, 0xEF, 0xFD, 0xBA, 0xDF, 0x00, 0x00,
	0x00, 0x00, 0xEF, 0xAA, 0x55, 0x77, 0x00, 0x00,
	0x00, 0x00, 0xBF, 0xAA, 0x55, 0x77, 0x00, 0x00,
	0x00, 0x00, 0xBF, 0xAA, 0x00, 0xBF, 0xAA, 0x00,
	0x00, 0x00, 0xFB, 0xF5, 0x00, 0xBF, 0xAA, 0x00,
	0x40, 0x80, 0xBF, 0xAA, 0x00, 0xFB, 0xAA, 0x00,
	0x40, 0xD5, 0x3F, 0xEA, 0xC0, 0xBF, 0xAA, 0x00,
	0x00, 0xD5, 0xFF, 0xC0, 0xC0, 0xBF, 0xAA, 0x00,
	0x00, 0x40, 0xC0, 0xC0, 0xC0, 0xFF, 0xAA, 0x00};


const u8 G_malo_cerca_muerte1[232] = {
	0x00, 0x00, 0x00, 0x00, 0x55, 0xFF, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xFA, 0xF5, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xBA, 0x24, 0xAA, 0x00,
	0x00, 0x00, 0x00, 0x55, 0x24, 0x18, 0x75, 0x00,
	0x00, 0x00, 0x14, 0x55, 0xB0, 0x70, 0x75, 0x00,
	0x00, 0x10, 0x00, 0x00, 0xFA, 0xB0, 0xAA, 0x00,
	0x00, 0x34, 0x30, 0x14, 0xBA, 0x70, 0xAA, 0x00,
	0x00, 0x10, 0x3C, 0x20, 0x64, 0xB0, 0x0A, 0x00,
	0x00, 0x10, 0x3C, 0x30, 0x3C, 0x34, 0x20, 0x00,
	0x00, 0x00, 0x34, 0x38, 0x34, 0x38, 0xAA, 0x00,
	0x00, 0x14, 0x10, 0x30, 0x98, 0x75, 0xDD, 0x00,
	0x00, 0x00, 0x34, 0x34, 0x25, 0x0F, 0xDD, 0x00,
	0x00, 0x28, 0x10, 0x7D, 0x7D, 0x8D, 0x5F, 0x00,
	0x00, 0x00, 0x00, 0xFA, 0xFA, 0xAF, 0xDD, 0x00,
	0x00, 0x00, 0x28, 0xFA, 0xFA, 0xEE, 0x5F, 0x00,
	0x00, 0x00, 0x00, 0xFF, 0xDD, 0x0F, 0xAA, 0x00,
	0x00, 0x00, 0x55, 0xF5, 0xFC, 0xDD, 0x00, 0x00,
	0x00, 0x00, 0x55, 0xFF, 0x6D, 0xFD, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x67, 0xCF, 0x77, 0x00, 0x00,
	0x00, 0x00, 0xBB, 0xDE, 0xB9, 0xDF, 0x00, 0x00,
	0x00, 0x00, 0xEF, 0xFD, 0xB9, 0xDF, 0x00, 0x00,
	0x00, 0x00, 0xEF, 0xAA, 0xEF, 0xDF, 0x00, 0x00,
	0x00, 0x55, 0x7F, 0x00, 0xEF, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x7F, 0x00, 0xEF, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0xF2, 0xAA, 0xBF, 0xAA, 0x00, 0x00,
	0x00, 0x55, 0x7F, 0x80, 0xBF, 0xAA, 0x00, 0x00,
	0x00, 0xBF, 0x7F, 0xC0, 0xFB, 0xEA, 0x80, 0x00,
	0x00, 0xFF, 0xEA, 0xC0, 0xBF, 0xEA, 0xC0, 0x00,
	0x00, 0xC0, 0xC0, 0x00, 0xFF, 0xEA, 0x80, 0x00};


const u8 G_malo_cerca_muerte2[232] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x34, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x20, 0x28, 0x00, 0x00, 0x55, 0xFF, 0x00,
	0x00, 0x00, 0x20, 0x00, 0x00, 0xFA, 0xF5, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xBA, 0x24, 0xAA,
	0x00, 0x00, 0x00, 0x00, 0x55, 0x24, 0x18, 0x75,
	0x00, 0x00, 0x00, 0x00, 0x55, 0xB0, 0x70, 0x75,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFA, 0xB0, 0xAA,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xBA, 0x70, 0xAA,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xEE, 0xB0, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xBA, 0x3C, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x55, 0x3C, 0x75, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x55, 0x30, 0xEE, 0xAA,
	0x00, 0x00, 0x00, 0x00, 0xFF, 0x2D, 0x4E, 0xAA,
	0x00, 0x00, 0x00, 0x55, 0xB4, 0xBE, 0x0F, 0xAA,
	0x00, 0x00, 0x00, 0x55, 0xF5, 0xF5, 0x4E, 0xAA,
	0x00, 0x00, 0x55, 0xFF, 0xFF, 0xF5, 0x8D, 0xAA,
	0x55, 0x00, 0xBB, 0xDF, 0xEE, 0xBE, 0x5F, 0x00,
	0xBF, 0xFF, 0xEF, 0xEF, 0x76, 0xEC, 0xEA, 0x80,
	0xBF, 0xF7, 0x7F, 0xE7, 0x9B, 0xDE, 0xEA, 0xC0,
	0xD5, 0xF7, 0xB7, 0x7F, 0xEF, 0xDF, 0xC0, 0x80,
	0xC0, 0xFF, 0xBF, 0xEA, 0xD5, 0xEA, 0xC0, 0x00,
	0x40, 0xC0, 0xD5, 0xC0, 0xC0, 0xC0, 0x00, 0x00};


/********** END ENEMIES **************/
